<!DOCTYPE html>
<html lang="en">

<head>

    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="">
    <meta name="author" content="">

    <title><?= $title ?> | <?= $company['company_name'] ?></title>

    <!-- Custom fonts for this template-->
    <link href="<?= base_url('assets/backend/') ?>vendor/fontawesome-free/css/all.min.css" rel="stylesheet" type="text/css">
    <link href="https://fonts.googleapis.com/css?family=Nunito:200,200i,300,300i,400,400i,600,600i,700,700i,800,800i,900,900i" rel="stylesheet">

    <!-- Custom styles for this template-->
    <link href="<?= base_url('assets/backend/') ?>css/sb-admin-2.min.css" rel="stylesheet">

</head>

<body class="bg-gradient-primary">
    <div class="container">

        <div class="card o-hidden border-0 shadow-lg my-5 col-lg-5 mx-auto ">
            <div class="card-body p-0">
                <!-- Nested Row within Card Body -->
                <div class="row">
                    <div class="col-lg">
                        <div class="p-5">
                            <div class="text-center">
                                <img class="mb-3" style=" display: block;margin-left: auto;margin-right: auto;width: 100%;" src="<?= base_url('assets/images/') ?><?= $company['logo'] ?>" alt="">
                                <h1 class="h4 text-gray-900 mb-4">Daftar <?= $company['company_name']; ?> </h1>
                            </div>
                            <?= $this->session->flashdata('message') ?>
                            <?php echo form_open_multipart('auth/register') ?>
                            <div class="form-group">
                                <input type="hidden" name="no_services" value="<?= Date('ymdHis') ?>">
                                <input type="text" class="form-control form-control-user" id="name" name="name" placeholder="Nama Lengkap" value="<?= set_value('name') ?>">
                                <?= form_error('name', '<small class="text-danger pl-3 ">', '</small>') ?>
                            </div>
                            <div class="form-group">
                                <input type="text" class="form-control form-control-user" id="Email" name="email" placeholder="Alamat Email" value="<?= set_value('email') ?>">
                                <?= form_error('email', '<small class="text-danger pl-3 ">', '</small>') ?>
                            </div>
                            <div class="form-group">
                                <input type="number" class="form-control form-control-user" id="no_wa" name="no_wa" placeholder="No Whatsapp" value="<?= set_value('no_wa') ?>">
                                <?= form_error('no_wa', '<small class="text-danger pl-3 ">', '</small>') ?>
                            </div>
                            <label for="no_ktp">ID Card</label>
                            <div class="form-group row">
                                <div class="col-sm-4 mb-3 mb-sm-0">
                                    <select name="type_id" id="type_id" class="form-control" required>
                                        <option value="">-Pilih-</option>
                                        <option value="KTP">KTP</option>
                                        <option value="SIM">SIM</option>
                                        <option value="NPWP">NPWP</option>
                                        <option value="Pasport">Pasport</option>
                                    </select>
                                </div>
                                <div class="col-sm-8">
                                    <input type="text" id="no_ktp" name="no_ktp" class="form-control" value="<?= set_value('no_ktp') ?>">
                                    <?= form_error('no_ktp', '<small class="text-danger pl-3 ">', '</small>') ?>
                                </div>
                            </div>

                            <div class="form-group row">
                                <div class="col-sm-6 mb-3 mb-sm-0">
                                    <input type="password" class="form-control form-control-user" id="Password1" name="password1" placeholder="Password">
                                    <?= form_error('password1', '<small class="text-danger pl-3 ">', '</small>') ?>
                                </div>
                                <div class="col-sm-6">
                                    <input type="password" class="form-control form-control-user" id="Password2" name="password2" placeholder="Konfirmasi Password">
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="address">Alamat</label>
                                <textarea id="address" autocomplete="off" name="address" class="form-control"> </textarea>
                            </div>
                            <div class="form-group">
                                <label for="paket">Paket Langganan</label>
                                <?php $item = $this->db->get_where('package_item', ['public' => 1])->result() ?>
                                <select name="paket" id="paket" class="form-control" required>
                                    <option value="">-Pilih Paket-</option>
                                    <?php foreach ($item as $item) { ?>
                                        <option value="<?= $item->p_item_id ?>"><?= $item->name ?> - Rp. <?= indo_currency($item->price); ?></option>
                                    <?php } ?>
                                </select>
                            </div>
                            <div class="row">
                                <div class="col-1">
                                    <input type="checkbox" required>
                                </div>
                                <div class="col-11">
                                    <label><span></span> Saya menyetujui <a href="<?= site_url('syarat-dan-ketentuan.html') ?>" style="text-decoration: none;">Syarat & Ketentuan</a> dan <a href="<?= site_url('kebijakan-privasi.html') ?>" style="text-decoration: none;">Kebijakan Privasi</a> yang berlaku</label>
                                </div>

                            </div>
                            <button type="submit" class="btn btn-primary btn-user btn-block">
                                DAFTAR
                            </button>
                            </form>
                            <hr>
                            <div class="text-center">
                                <a class="small" href="<?= site_url('auth/forgotpassword'); ?>">Lupa Password?</a>
                            </div>
                            <div class="text-center">
                                <a class="small" href="<?= site_url('auth') ?>">Sudah punya akun ?</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Bootstrap core JavaScript-->
    <script src="<?= base_url('assets/backend/') ?>vendor/jquery/jquery.min.js"></script>
    <script src="<?= base_url('assets/backend/') ?>vendor/bootstrap/js/bootstrap.bundle.min.js"></script>

    <!-- Core plugin JavaScript-->
    <script src="<?= base_url('assets/backend/') ?>vendor/jquery-easing/jquery.easing.min.js"></script>

    <!-- Custom scripts for all pages-->
    <script src="<?= base_url('assets/backend/') ?>js/sb-admin-2.min.js"></script>

</body>

</html>