<?php defined('BASEPATH') or exit('No direct script access allowed');

class Setting extends CI_Controller
{
    function __construct()
    {
        parent::__construct();
        is_logged_in();
        $this->load->model(['setting_m', 'customer_m']);
    }


    public function index()
    {
        $data['title'] = 'Setting';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['company'] = $this->db->get('company')->row_array();
        $data['country'] = $this->db->get('country')->result();

        $this->template->load('backend', 'backend/setting/company', $data);
    }
    public function schedule()
    {
        $data['title'] = 'Schedule';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['company'] = $this->db->get('company')->row_array();
        $data['other'] = $this->db->get('other')->row_array();
        $data['country'] = $this->db->get('country')->result();
        $this->template->load('backend', 'backend/setting/schedule', $data);
    }
    public function setschedule()
    {
        $post = $this->input->post(null, TRUE);
        $this->db->set('date_create', $post['date_create']);
        $this->db->set('key_apps', $post['key_apps']);
        $this->db->update('other');

        if ($this->db->affected_rows() > 0) {
            $this->session->set_flashdata('success', 'Data berhasil diperbaharui');
        }
        redirect('setting/schedule');
    }
    public function editCompany()
    {
        $config['upload_path']          = './assets/images';
        $config['allowed_types']        = 'gif|jpg|png|jpeg';
        $config['max_size']             = 10048; // 10 Mb
        $config['file_name']             = 'logo';
        $this->load->library('upload', $config);
        $post = $this->input->post(null, TRUE);
        if (@FILES['logo']['name'] != null) {
            if ($this->upload->do_upload('logo')) {
                $company = $this->setting_m->getCompany($post['id'])->row();
                if ($company->logo != null) {
                    $target_file = './assets/images/' . $company->logo;
                    unlink($target_file);
                }
                $post['logo'] =  $this->upload->data('file_name');
                $this->setting_m->editCompany($post);
                if ($this->db->affected_rows() > 0) {
                    $this->session->set_flashdata('success', 'Data perusahaan berhasil diperbaharui');
                }
                echo "<script>window.location='" . site_url('setting') . "'; </script>";
            } else {
                $post['logo'] =  null;
                $this->setting_m->editCompany($post);
                if ($this->db->affected_rows() > 0) {
                    $this->session->set_flashdata('success', 'Data perusahaan berhasil diperbaharui');
                }
                echo "<script>window.location='" . base_url('setting') . "'; </script>";
            }
        } else {
            $error = $this->upload->display_errors();
            $this->session->set_flashdata('error', $error);
            echo "<script>window.location='" . base_url('setting') . "'; </script>";
        }
    }

    public function about()
    {
        $data['title'] = 'About';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['company'] = $this->db->get('company')->row_array();
        $this->template->load('backend', 'backend/setting/about', $data);
    }
    public function editAbout()
    {
        $description = $this->input->post('description');
        $this->db->set('description', $description);
        $this->db->update('company');
        $this->session->set_flashdata('success', 'Deskripsi perusahaan sudah diperbaharui.
      ');
        redirect('setting/about');
    }

    public function bank()
    {
        $data['title'] = 'Bank';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['bank'] = $this->setting_m->getBank()->result();
        $data['company'] = $this->db->get('company')->row_array();
        $this->template->load('backend', 'backend/setting/bank', $data);
    }

    public function addBank()
    {
        $post = $this->input->post(null, TRUE);
        $this->setting_m->addBank($post);
        if ($this->db->affected_rows() > 0) {
            $this->session->set_flashdata('success', 'Data Bank berhasil ditambahkan');
        }
        echo "<script>window.location='" . site_url('setting/bank') . "'; </script>";
    }
    public function editBank()
    {
        $post = $this->input->post(null, TRUE);
        $this->setting_m->editBank($post);
        if ($this->db->affected_rows() > 0) {
            $this->session->set_flashdata('success', 'Data Bank berhasil diperbaharui');
        }
        echo "<script>window.location='" . site_url('setting/bank') . "'; </script>";
    }
    public function deleteBank()
    {
        $bank_id = $this->input->post('bank_id');
        $this->setting_m->deleteBank($bank_id);
        if ($this->db->affected_rows() > 0) {
            $this->session->set_flashdata('success', 'Data Bank berhasil dihapus');
        }
        echo "<script>window.location='" . site_url('setting/bank') . "'; </script>";
    }
    public function backup()
    {
        $data['title'] = 'Backup';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['company'] = $this->db->get('company')->row_array();
        $this->template->load('backend', 'backend/setting/backup', $data);
    }
    public function backupdatabase()
    {
        $company = $this->db->get('company')->row_array();
        $this->load->dbutil();
        $this->load->dbutil();
        $config = array(
            'format'    => 'zip',
            'filename'    => 'Backup-My-Wifi-' . $company['company_name'] . '-' . date("YmdHis") . '-db.sql'
        );

        $backup = $this->dbutil->backup($config);

        $this->load->helper('file');

        $this->load->helper('download');
        force_download('Backup-My-Wifi-' . $company['company_name'] . '-' . date("YmdHis") . '-db.zip', $backup);
    }

    public function email()
    {
        $data['title'] = 'Email';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['company'] = $this->db->get('company')->row_array();
        $data['email'] = $this->db->get('email')->row_array();
        $this->template->load('backend', 'backend/setting/email', $data);
    }

    public function editEmail()
    {
        $post = $this->input->post(null, TRUE);
        $this->setting_m->editEmail($post);
        if ($this->db->affected_rows() > 0) {
            $this->session->set_flashdata('success', 'Data Email berhasil diperbaharui');
        }
        echo "<script>window.location='" . site_url('setting/email') . "'; </script>";
    }
    public function other()
    {
        $data['title'] = 'Lainnya';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['company'] = $this->db->get('company')->row_array();
        $data['other'] = $this->db->get('other')->row_array();
        $this->template->load('backend', 'backend/setting/other', $data);
    }

    public function editOther()
    {
        $post = $this->input->post(null, TRUE);
        $this->setting_m->editOther($post);
        if ($this->db->affected_rows() > 0) {
            $this->session->set_flashdata('success', 'Data berhasil diperbaharui');
        }
        echo "<script>window.location='" . site_url('setting/other') . "'; </script>";
    }

    public function editphp()
    {
        $data['title'] = 'Lainnya';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['company'] = $this->db->get('company')->row_array();
        $data['customer'] = $this->customer_m->getCustomer()->result();
        $data['sms'] = $this->db->get('sms_gateway')->row_array();
        $this->template->load('backend', 'backend/setting/editphp', $data);
    }


    public function bottelegram()
    {
        $data['title'] = 'Bot Telegram';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['company'] = $this->db->get('company')->row_array();
        $data['customer'] = $this->customer_m->getCustomer()->result();
        $data['bot'] = $this->db->get('bot_telegram')->row_array();
        $this->template->load('backend', 'backend/setting/bot-telegram', $data);
    }
    public function editbottelegram()
    {
        $post = $this->input->post(null, TRUE);
        $this->setting_m->editbottelegram($post);
        if ($this->db->affected_rows() > 0) {
            $this->session->set_flashdata('success', 'Data Bot berhasil diperbaharui');
        }
        echo "<script>window.location='" . site_url('setting/bottelegram') . "'; </script>";
    }
    public function terms()
    {
        $data['title'] = 'Syarat dan Ketentuan';

        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['company'] = $this->db->get('company')->row_array();
        $this->template->load('backend', 'backend/setting/terms', $data);
    }
    public function policy()
    {
        $data['title'] = 'Kebijakan Privasi';

        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['company'] = $this->db->get('company')->row_array();
        $this->template->load('backend', 'backend/setting/policy', $data);
    }
    public function editterms()
    {
        $terms = $this->input->post('terms');
        $this->db->set('terms', $terms);
        $this->db->update('company');
        $this->session->set_flashdata('success', 'Syarat dan ketentuan sudah diperbaharui.
      ');
        redirect('setting/terms');
    }
    public function editpolicy()
    {
        $policy = $this->input->post('policy');
        $this->db->set('policy', $policy);
        $this->db->update('company');
        $this->session->set_flashdata('success', 'Kebijakan privasi sudah diperbaharui.
      ');
        redirect('setting/policy');
    }
    public function expired()
    {
        $data['title'] = 'Expired';
        $data['user'] = $this->db->get_where('user', ['email' => $this->session->userdata('email')])->row_array();
        $data['company'] = $this->db->get('company')->row_array();
        $this->load->view('backend/setting/expired', $data);
    }
    public function updateexpired()
    {
        $new_date = $this->input->post('new_date');
        $isolir = $this->input->post('isolir');
        $this->db->set('expired', $new_date);
        $this->db->set('isolir', $isolir);
        $this->db->where('id', 1);
        $this->db->update('company');
        $this->session->set_flashdata('success', '
        Expired date has been changed !
     ');
        redirect('dashboard');
    }
}
